---
layout: page
title: حول
permalink: about/
lang: ar
---
<p class="message">
  <b>Polyglot</b> هو إضافة مفتوحة المصدر للتدويل لمدونات <a href="http://jekyllrb.com">Jekyll</a>. Polyglot سهل الإعداد والاستخدام مع أي مشروع، ويتوسع للغات التي تريد دعمها. مع دعم الاحتياطي للمحتوى المفقود، وإعادة توجيه URL التلقائي، و<a href="{{site.baseurl}}/seo/">وصفات SEO قوية</a>، يسمح Polyglot لأي مدونة متعددة اللغات بالتركيز على المحتوى دون التعقيد.
</p>

_`jekyll-polyglot` غير مدعوم بعد بشكل أصلي في github-actions_

### التثبيت

{% highlight bash %}
gem install jekyll-polyglot
{% endhighlight %}

### إدارة اللغات المدعومة

في `_config.yml`، تدير الخصائص التالية اللغات التي يدعمها موقعك. يمكنك توفير دعم للغة جديدة بإضافتها إلى هذه القيم (انظر أدناه). يتم تحديد اللغات بواسطة [رموز المنطقة](https://developer.chrome.com/webstore/i18n) الرسمية الخاصة بها.
```yml
languages: ["en", "es", "fr", "de"]
default_lang: "en"
exclude_from_localization: ["images", "fonts", "sitemap"]
url: https://polyglot.untra.io
```
* `languages:` مصفوفة من رموز المنطقة تحدد اللغات المدعومة من الموقع.
* `default_lang:` اللغة الافتراضية للموقع.
* `exclude_from_localization:` المجلدات والأدلة التي هي جزء من الموقع المبني، ولكن لا تحتاج إلى ترجمة. هذا بشكل رئيسي لتقليل أوقات البناء، ولأن ملفات الأصول مثل الصور والخطوط هي أجزاء كبيرة من الموقع، يضمن عدم "ترجمتها" أو تكرارها بشكل غير ضروري في المخرجات.
* `url` رابط موقعك الإلكتروني الثابت للإنتاج.

### إضافة لغة جديدة
بافتراض أن لديك بالفعل موقعًا وظيفيًا بلغة واحدة، فإن إضافة لغة جديدة لن تكون بسيطة. _لإنشاء موقع متعدد اللغات حقًا، يجب أن تتوقع إعادة إنشاء كل محتواك باللغة الجديدة._ قد يبدو هذا مهمة كبيرة، لكن فكر في الترجمة على أجزاء. المحتوى هو الملك؛ من الأهم أن تحصل الصفحات والمنشورات الجديدة على ترجمات محدثة. إنشاء موقع متعدد اللغات صعب فقط إذا طلبت أن يكون مترجمًا بشكل مثالي من البداية.

أولاً، يجب عليك (وفريقك، ومديريك أيضًا إذا كان لديك بعض منهم) مناقشة واختيار المحتوى الذي تحتاج لترجمته للموقع الجديد. يجب اختيار المحتوى الأساسي المفضل للترجمة. ضع في اعتبارك التحليلات والصفحات والمنشورات الشائعة وتدفق المستخدمين الحاليين والمستقبليين إلى موقعك. عند الشك، أعط الأولوية للصفحات على منشورات المدونة القديمة. إذا كان ذلك يعني إطلاق لغة جديدة في وقت أقرب، فقد تتطلب المنشورات القديمة جهدًا أكثر مما تستحق للترجمة.

ثانيًا، يجب عليك (أو يُوصى بشدة) توفير تغطية 100% للمحتوى الغني عبر موقعك. هذه سلاسل صغيرة مضمنة بطرق أكثر تعقيدًا. هناك طرق متعددة للتكرار على المحتوى الغني. تذكر، يجب عليك دعم جميع السلاسل الصغيرة بجميع اللغات في المحتوى الغني الخاص بك.

#### المحتوى متعدد اللغات
يأتي محتوى الموقع في نوعين: **أساسي** و**غني**.

المحتوى الأساسي هو النص العادي لمنشورات المدونة والصفحات والمحتوى غير التفاعلي. فكر في الصفحات والمنشورات. المحتوى الأساسي هو وقود نقرات موقعك. يوفر Polyglot دعم احتياطي للمحتوى الأساسي.

المحتوى الغني تفاعلي ولافت ومكون من سلاسل أقصر. فكر في أشرطة التنقل والقوائم المنسدلة. المحتوى الغني أكثر تقنية ويبقي زوارك على الموقع. _لا يوجد دعم احتياطي للمحتوى الغني المفقود._

#### أدوات Liquid
أدوات Liquid التالية متاحة للاستخدام مع jekyll-polyglot:

* **site.languages**

{% highlight html %}
{% raw %}
{% for lang in site.languages %}
  {{lang}}
{% endfor %}
{% endraw %}
{% endhighlight %}

`site.languages` يشير مباشرة إلى مصفوفة `languages` في _config.yml. يمكن الوصول إليه عبر Liquid.

* **site.default_lang**
{% highlight html %}
{% raw %}
  {{site.default_lang}}
{% endraw %}
{% endhighlight %}

`site.default_lang` يشير مباشرة إلى سلسلة `default_lang` في _config.yml. يمكن الوصول إليه عبر Liquid.

* **site.active_lang**
{% highlight html %}
{% raw %}
{% if site.active_lang == "es" %}
  <h1>Hola! Como estas?</h1>
{% endif %}
{% endraw %}
{% endhighlight %}
`site.active_lang` هو رمز المنطقة الذي يتم بناء الصفحة له. هذا `"de"` للنسخة الألمانية من الصفحة، `"es"` للنسخة الإسبانية، وهكذا. يمكن الوصول إليه عبر Liquid.

باستخدام هذه الأدوات، يمكنك تحديد كيفية إرفاق المحتوى الغني الصحيح.

* **page.rendered_lang**
{% highlight html %}
{% raw %}
{% if page.rendered_lang == site.active_lang %}
  <p>Welcome to our {{ site.active_lang }} webpage!</p>
{% else %}
  <p>webpage available in {{ page.rendered_lang }} only.</p>
{% endif %}
{% endraw %}
{% endhighlight %}

المتغير `page.rendered_lang` يشير إلى اللغة الفعلية لمحتوى الصفحة، مما يسمح للقوالب باكتشاف متى يتم تقديم الصفحة كمحتوى احتياطي.

### دعم Github Pages
بشكل افتراضي، يمنع Github [مدونات Jekyll من استخدام الإضافات](https://help.github.com/articles/using-jekyll-with-pages/#configuration-overrides). يتم ذلك عمدًا لمنع تشغيل التعليمات البرمجية الضارة على خوادم Github. على الرغم من أن هذا يجعل استخدام Polyglot (وإضافات Jekyll الأخرى) أصعب، إلا أنه لا يزال ممكنًا.

#### بناء `_site/` إلى gh-pages
بدلاً من استضافة محرك مدونة Jekyll على Github، يمكنك تطوير موقع Jekyll الخاص بك على فرع منفصل، ثم دفع محتويات `_site/` المبنية إلى فرع `gh-pages` الخاص بك. يتيح لك هذا إدارة والتحكم في إصدارات تطوير موقعك مع Github *دون الاعتماد على Github لبناء موقعك!*

يمكنك القيام بذلك عن طريق الحفاظ على محتوى Jekyll الخاص بك على فرع منفصل، والالتزام فقط بمجلد `_site/` إلى فرع gh-pages الخاص بك. لأن هذه مجرد صفحات HTML ثابتة في مجلدات، سيستضيفها Github مثل أي محتوى [gh-pages](https://pages.github.com/) آخر.

#### أتمتة ذلك!

تُساعد هذه العملية بشكل كبير بواسطة سكريبت بسيط سيبني موقعك ويلتزم بمجلد `_site/` إلى gh-pages الخاص بك. كثير من الناس لديهم واحد. [هنا واحد](http://www.jokecamp.com/blog/Simple-jekyll-deployment-with-a-shell-script-and-github/). [هنا آخر](https://gist.github.com/cobyism/4730490). هنا [سكريبت النشر الخاص بي](https://github.com/untra/polyglot/blob/main/publi.sh):
```bash
#! /bin/sh
# غيّر أسماء الفروع وفقًا لذلك
rm -rf site/_site/
cd site && bundle exec jekyll build && cd ..
git add site/_site/ && git commit -m "$(date)"
git subtree push --prefix site/_site origin gh-pages
```
