use super::util;

const TEST: &str = "test";

#[derive(Debug, garde::Validate)]
struct Test<'a> {
    #[garde(prefix(TEST))]
    field: &'a str,
    #[garde(inner(prefix("test")))]
    inner: &'a [&'a str],
}

#[test]
fn prefix_valid() {
    util::check_ok(
        &[
            Test {
                field: "test",
                inner: &["test"],
            },
            Test {
                field: "test_asdf",
                inner: &["test_asdf"],
            },
        ],
        &(),
    )
}

#[test]
fn prefix_invalid() {
    util::check_fail!(
        &[
            Test {
                field: "a",
                inner: &["a"]
            },
            Test {
                field: "_test",
                inner: &["_test"]
            }
        ],
        &()
    )
}
