/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.objects.FunctionObject;

public class Romberg {
    private static double sumUp(FunctionObject functionObject, double d2, double d3, int n) throws ConstructionException {
        double d4 = functionObject.evaluateF(d2);
        for (int i = 1; i <= n; ++i) {
            d4 += functionObject.evaluateF(d2 + (double)i * d3);
        }
        return d4;
    }

    public static double compute(FunctionObject functionObject, double d2, double d3, int n, double d4, int n2) throws ConstructionException {
        double d5;
        double[] dArray = new double[n2];
        int n3 = n;
        double d6 = (d3 - d2) / (double)n3;
        double d7 = d5 = (dArray[0] = (functionObject.evaluateF(d2) + functionObject.evaluateF(d3) + 2.0 * Romberg.sumUp(functionObject, d2 + d6, d6, n3 - 2)) * d6 / 2.0);
        double d8 = dArray[0];
        for (int i = 1; i < n2; ++i) {
            dArray[i] = d5 / 2.0 + Romberg.sumUp(functionObject, d2 + (d6 /= 2.0), 2.0 * d6, (n3 *= 2) / 2 - 1) * d6;
            d7 = d5;
            d5 = dArray[i];
            double d9 = 4.0;
            for (int j = i - 1; j >= 0; --j) {
                dArray[j] = dArray[j + 1] + (dArray[j + 1] - dArray[j]) / (d9 - 1.0);
                d9 *= 4.0;
            }
            double d10 = dArray[0];
            if (Math.abs((d10 - d8) / d10) < d4) {
                return d10;
            }
            d8 = d10;
        }
        return d5;
    }
}

