/* Bits taken from <linux/mount.h>. Needed for libcs with <sys/mount.h>
 * without mount_setattr. This is the case for musl (as of v1.2.6).
 */
#include <syscall.h>
#include <sys/mount.h>
#if defined(SYS_mount_setattr) && !defined(MOUNT_ATTR_RDONLY)
#include <stdint.h>

#define MOUNT_ATTR_RDONLY       0x00000001

struct mount_attr {
  uint64_t attr_set;
  uint64_t attr_clr;
  uint64_t propagation;
  uint64_t userns_fd;
};

static inline int mount_setattr(int dirfd, const char *path, unsigned int flags, struct mount_attr *attr, size_t size) {
  return syscall(SYS_mount_setattr, dirfd, path, flags, attr, size);
}
#endif

