# Express Charter

## Section 0: Guiding Principles

The Express project is part of the OpenJS Foundation which operates
transparently, openly, collaboratively, and ethically.
Project proposals, timelines, and status must not merely be open, but
also easily visible to outsiders.

## Section 1: Scope

Express is a HTTP web server framework with a simple and expressive API
which is highly aligned with Node.js core. We aim to be the best in
class for writing performant, spec compliant, and powerful web servers
in Node.js. As one of the oldest and most popular web frameworks in
the ecosystem, we have an important place for new users and experts
alike.

### 1.1: In-scope

Express is made of many modules spread between three GitHub Orgs:

- [expressjs](http://github.com/expressjs/): Top level middleware and
  libraries
- [pillarjs](http://github.com/pillarjs/): Components which make up
  Express but can also be used for other web frameworks
- [jshttp](http://github.com/jshttp/): Low level HTTP libraries

### 1.2: Out-of-Scope

Section Intentionally Left Blank

## Section 2: Relationship with OpenJS Foundation CPC.

Technical leadership for the projects within the OpenJS Foundation is
delegated to the projects through their project charters by the OpenJS
Cross Project Council (CPC). In the case of the Express project, it is
delegated to the Express Technical Committee ("TC").

This Technical Committee is in charge of both the day-to-day operations
of the project, as well as its technical management. This charter can
be amended by the TC requiring at least two approvals and a minimum two
week comment period for other TC members or CPC members to object. Any
changes the CPC wishes to propose will be considered a priority but
will follow the same process.

### 2.1 Other Formal Project Relationships

Section Intentionally Left Blank

## Section 3: Express Governing Body

The Express project is managed by the Technical Committee ("TC").
Members can be added to the TC at any time. Any committer can nominate
another committer to the TC and the TC uses its standard consensus
seeking process to evaluate whether or not to add this new member.
Members who do not participate consistently at the level of a majority
of the other members are expected to resign.

## Section 4: Roles & Responsibilities

The Express TC manages all aspects of both the technical and community
parts of the project. Members of the TC should attend the regular
meetings when possible, and be available for discussion of time
sensitive or important issues.

### Section 4.1 Project Operations & Management

Section Intentionally Left Blank

### Section 4.2: Decision-making, Voting, and/or Elections

The Express TC uses a "consensus seeking" process for issues that are
escalated to the TC. The group tries to find a resolution that has no
open objections among TC members. If a consensus cannot be reached
that has no objections then a majority wins vote is called. It is also
expected that the majority of decisions made by the TC are via a
consensus seeking process and that voting is only used as a last-resort.

Resolution may involve returning the issue to committers with
suggestions on how to move forward towards a consensus. It is not
expected that a meeting of the TC will resolve all issues on its
agenda during that meeting and may prefer to continue the discussion
happening among the committers.

### Section 4.3: Other Project Roles

Section Intentionally Left Blank

## Section 5: Definitions

Section Intentionally Left Blank
