<?php

declare(strict_types=1);

/*
 * This file is part of the league/commonmark package.
 *
 * (c) Colin O'Dell <colinodell@gmail.com> and uAfrica.com (http://uafrica.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace League\CommonMark\Tests\Unit\Extension\Highlight;

use League\CommonMark\Exception\InvalidArgumentException;
use League\CommonMark\Extension\Highlight\Mark;
use League\CommonMark\Extension\Highlight\MarkRenderer;
use League\CommonMark\Node\Inline\Text;
use League\CommonMark\Tests\Unit\Renderer\FakeChildNodeRenderer;
use League\CommonMark\Util\HtmlElement;
use PHPUnit\Framework\TestCase;

final class MarkRendererTest extends TestCase
{
    private MarkRenderer $renderer;

    protected function setUp(): void
    {
        $this->renderer = new MarkRenderer();
    }

    public function testRender(): void
    {
        $inline = new Mark('==');
        $inline->data->set('attributes/id', 'some"&amp;id');
        $fakeRenderer = new FakeChildNodeRenderer();
        $fakeRenderer->pretendChildrenExist();

        $result = $this->renderer->render($inline, $fakeRenderer);

        $this->assertTrue($result instanceof HtmlElement);
        $this->assertEquals('mark', $result->getTagName());
        $this->assertStringContainsString('::children::', $result->getContents(true));
        $this->assertEquals(['id' => 'some"&amp;id'], $result->getAllAttributes());
    }

    public function testRenderWithInvalidNodeType(): void
    {
        $this->expectException(InvalidArgumentException::class);

        $inline       = new Text('ruh roh');
        $fakeRenderer = new FakeChildNodeRenderer();

        $this->renderer->render($inline, $fakeRenderer);
    }
}
