# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.weightsandbiases import WeightsAndBiasesMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-weightsandbiases
# USAGE
    python instances_create_or_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = WeightsAndBiasesMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.instances.begin_create_or_update(
        resource_group_name="rgopenapi",
        instancename="myinstance",
        resource={
            "identity": {"type": "None", "userAssignedIdentities": {}},
            "location": "pudewmshbcvbt",
            "properties": {
                "marketplace": {
                    "offerDetails": {
                        "offerId": "rfgoevxeke",
                        "planId": "ufopn",
                        "planName": "adysakgqlryufffz",
                        "publisherId": "kf",
                        "termId": "kklscqq",
                        "termUnit": "dgrkojow",
                    },
                    "subscriptionId": "00000000-0000-0000-0000-000000000000",
                    "subscriptionStatus": "PendingFulfillmentStart",
                },
                "partnerProperties": {"region": "eastus", "subdomain": "xkecokwnwtkwnkxfgucmzybzzb"},
                "singleSignOnProperties": {
                    "aadDomains": ["mxnw"],
                    "enterpriseAppId": "hkxtmpv",
                    "state": "Initial",
                    "type": "Saml",
                    "url": "iqlemoksqdygqyxpp",
                },
                "user": {
                    "emailAddress": "user@outlook.com",
                    "firstName": "kiiehcojcldrlndoid",
                    "lastName": "zhkvsfqvthwkfkvgxcruyud",
                    "phoneNumber": "cogmqmuwfcpstkwbzgkgo",
                    "upn": "rmjpgqchpbw",
                },
            },
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: 2024-09-18/Instances_CreateOrUpdate_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
